#include <bits/stdc++.h>
using namespace std;

struct Vec {
    double ugao;
    long long x, y;
    int id;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<Vec> v(n);

    for (int i = 0; i < n; i++) {
        long long x, y;
        cin >> x >> y;
        v[i].x = x;
        v[i].y = y;
        v[i].ugao = atan2((double)y, (double)x);
        v[i].id = i + 1;
    }

    sort(v.begin(), v.end(), [](const Vec &a, const Vec &b){
        return a.ugao < b.ugao;
    });
    
    vector<Vec> w(2*n);
    for (int i = 0; i < n; i++) w[i] = v[i];
    for (int i = 0; i < n; i++) {
        w[n+i] = v[i];
        w[n+i].ugao += 2 * M_PI;
    }

    long long trX = 0, trY = 0;
    long long najboljiX = 0, najboljiY = 0;
    long long bestic = 0;

    int l = 0;
    vector<int> bestindi;
    multiset<int> currindi;
    for (int r = 0; r < 2*n; r++) {
        trX += w[r].x;
        trY += w[r].y;
        currindi.insert(w[r].id);
        while (w[r].ugao - w[l].ugao > M_PI) {
            trX -= w[l].x;
            trY -= w[l].y;
            currindi.erase(currindi.find(w[l].id));
            l++;
        }

        long long val = trX*trX + trY*trY;
        if (val > bestic) {
            bestic = val;
            najboljiX = trX;
            najboljiY = trY;

            bestindi.clear();
            for (int x : currindi) bestindi.push_back(x);
        }
    }

    cout << bestindi.size() << "\n";
    for (int id : bestindi) cout << id << " ";
    cout << "\n";

    return 0;
}